(function ($) {

  Drupal.admin = Drupal.admin || {};
  Drupal.admin.behaviors = Drupal.admin.behaviors || {};

  /**
   * @ingroup admin_behaviors
   * @{
   */

  /**
   * Apply active trail highlighting based on current path.
   *
   * @todo Not limited to toolbar; move into core?
   */
  Drupal.admin.behaviors.toolbarActiveTrail = function (context, settings, $adminMenu) {
    if (settings.admin_menu.toolbar && settings.admin_menu.toolbar.activeTrail) {
      $adminMenu.find('> div > ul > li > a[href="' + settings.admin_menu.toolbar.activeTrail + '"]').addClass('active-trail');
    }
  };

  Drupal.admin.behaviors.shorcutcollapsed = function (context, settings, $adminMenu) {

    // Create the dropdown base
    $('<li class="label"><a>' + Drupal.t('Shortcuts') + '</a></li>').prependTo("body.menu-render-collapsed #toolbar div.toolbar-shortcuts ul");

  };

  Drupal.admin.behaviors.shorcutselect = function (context, settings, $adminMenu) {

    // Create the dropdown base
    $('<select id="shortcut-menu"/>').appendTo("body.menu-render-dropdown #toolbar div.toolbar-shortcuts");

    // Create default option "Select"
    $("<option />", {
      "selected": "selected",
      "value": "",
      "text": Drupal.t('Shortcuts')
    }).appendTo("body.menu-render-dropdown #toolbar div.toolbar-shortcuts select");

    // Populate dropdown with menu items
    $("body.menu-render-dropdown #toolbar div.toolbar-shortcuts a").each(function () {
      var el = $(this);
      $("<option />", {
        "value": el.attr("href"),
        "text": el.text()
      }).appendTo("body.menu-render-dropdown #toolbar div.toolbar-shortcuts select");
    });

    $("body.menu-render-dropdown #toolbar div.toolbar-shortcuts select").change(function () {
      window.location = $(this).find("option:selected").val();
    });

    $('body.menu-render-dropdown #toolbar div.toolbar-shortcuts ul').remove();

  };

  // Ovveride front link if changed by another module for the mobile menu.
  Drupal.admin.behaviors.mobile_front_link = function (context, settings, $adminMenu) {
    $("ul.slicknav_nav li.admin-menu-toolbar-home-menu a>a").attr("href", $("#admin-menu-icon > li > a").attr('href'));
  };

})(jQuery);
